/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import snownee.jade.gui.ResizeableLayout;

public class LayoutWithPadding
implements Layout,
ResizeableLayout {
    private final LayoutElement wrapped;
    private final boolean resizeable;
    public int paddingLeft;
    public int paddingTop;
    public int paddingRight;
    public int paddingBottom;

    public LayoutWithPadding(LayoutElement wrapped) {
        this.wrapped = wrapped;
        this.resizeable = wrapped instanceof ResizeableLayout;
    }

    public LayoutWithPadding(LayoutElement wrapped, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this(wrapped);
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
    }

    public void visitChildren(Consumer<LayoutElement> consumer) {
        LayoutElement layoutElement = this.wrapped;
        if (layoutElement instanceof Layout) {
            Layout layout = (Layout)layoutElement;
            layout.visitChildren(consumer);
        } else {
            consumer.accept(this.wrapped);
        }
    }

    public void arrangeElements() {
        LayoutElement layoutElement = this.wrapped;
        if (layoutElement instanceof Layout) {
            Layout layout = (Layout)layoutElement;
            layout.arrangeElements();
            this.setPosition(layout.getX(), layout.getY());
        }
    }

    public int getWidth() {
        return this.wrapped.getWidth() + this.paddingLeft + this.paddingRight;
    }

    public int getHeight() {
        return this.wrapped.getHeight() + this.paddingTop + this.paddingBottom;
    }

    public void setX(int x) {
        this.wrapped.setX(x + this.paddingLeft);
    }

    public void setY(int y) {
        this.wrapped.setY(y + this.paddingTop);
    }

    public void setPosition(int x, int y) {
        this.wrapped.setPosition(x + this.paddingLeft, y + this.paddingTop);
    }

    public int getX() {
        return this.wrapped.getX() - this.paddingLeft;
    }

    public int getY() {
        return this.wrapped.getY() - this.paddingTop;
    }

    @Override
    public void setFreeSpace(int width, int height) {
        if (this.resizeable) {
            ((ResizeableLayout)this.wrapped).setFreeSpace(width - this.paddingLeft - this.paddingRight, height - this.paddingTop - this.paddingBottom);
            this.setPosition(this.wrapped.getX(), this.wrapped.getY());
        }
    }

    @Override
    public void setFlexGrow(int flexGrow) {
        if (this.resizeable) {
            ((ResizeableLayout)this.wrapped).setFlexGrow(flexGrow);
        }
    }

    @Override
    public int getFlexGrow() {
        return this.resizeable ? ((ResizeableLayout)this.wrapped).getFlexGrow() : 0;
    }
}

